/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.impl.simple;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.ValueEntry;
import com.mrcrayfish.configured.api.simple.EnumProperty;
import com.mrcrayfish.configured.api.simple.ListProperty;
import com.mrcrayfish.configured.impl.simple.SimpleConfigManager;
import com.mrcrayfish.configured.impl.simple.SimpleEnumValue;
import com.mrcrayfish.configured.impl.simple.SimpleListValue;
import com.mrcrayfish.configured.impl.simple.SimpleValue;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_2561;

public class SimpleFolderEntry
implements IConfigEntry {
    private final SimpleConfigManager.PropertyMap map;
    private List<IConfigEntry> entries;

    public SimpleFolderEntry(SimpleConfigManager.PropertyMap map) {
        this.map = map;
    }

    @Override
    public List<IConfigEntry> getChildren() {
        if (this.entries == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            this.map.getConfigMaps().forEach(pair -> builder.add((Object)new SimpleFolderEntry((SimpleConfigManager.PropertyMap)pair.getRight())));
            this.map.getConfigProperties().forEach(property -> {
                if (property instanceof ListProperty) {
                    ListProperty listProperty = (ListProperty)property;
                    builder.add((Object)new ValueEntry(new SimpleListValue(listProperty)));
                } else if (property instanceof EnumProperty) {
                    EnumProperty enumProperty = (EnumProperty)property;
                    builder.add((Object)new ValueEntry(new SimpleEnumValue(enumProperty)));
                } else {
                    builder.add((Object)new ValueEntry(new SimpleValue(property)));
                }
            });
            this.entries = builder.build();
        }
        return this.entries;
    }

    @Override
    public boolean isRoot() {
        return this.map.getPath().isEmpty();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    @Nullable
    public IConfigValue<?> getValue() {
        return null;
    }

    @Override
    public String getEntryName() {
        return SimpleFolderEntry.lastValue(this.map.getPath(), "Root");
    }

    @Override
    @Nullable
    public class_2561 getTooltip() {
        String key = this.map.getTranslationKey() + ".tooltip";
        if (class_1074.method_4663((String)key)) {
            return class_2561.method_43471((String)key);
        }
        String comment = this.map.getComment();
        if (comment != null) {
            return class_2561.method_43470((String)comment);
        }
        return null;
    }

    @Override
    @Nullable
    public String getTranslationKey() {
        return this.map.getTranslationKey();
    }

    public static <V> V lastValue(List<V> list, V defaultValue) {
        if (list.size() > 0) {
            return list.get(list.size() - 1);
        }
        return defaultValue;
    }
}

